% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{aggregate_byname}
\alias{aggregate_byname}
\title{Aggregate rows and columns in a matrix}
\usage{
aggregate_byname(
  a,
  aggregation_map = NULL,
  margin = c(1, 2),
  pattern_type = "exact"
)
}
\arguments{
\item{a}{A matrix or list of matrices whose rows or columns are to be aggregated.}

\item{aggregation_map}{A named list of rows or columns to be aggregated (or \code{NULL}). See \code{details}.}

\item{margin}{\code{1}, \code{2}, or \code{c(1, 2)} for row aggregation, column aggregation, or both.}

\item{pattern_type}{See \code{RCLabels::make_or_pattern()}.}
}
\value{
A version of \code{a} with aggregated rows and/or columns
}
\description{
Rows (\code{margin = 1}), columns (\code{margin = 2}), or both (\code{margin = c(1, 2)}, the default)
are aggregated according to \code{aggregation_map}.
}
\details{
When \code{aggregation_map} is \code{NULL} (the default),
rows (or columns or both) of same name are aggregated together.

If \code{aggregation_map} is not \code{NULL}, it must be a named list.
The name of each \code{aggregation_map} item is the name of a row or column in output
that will contain the specified aggregation.
The value of each item in \code{aggregation_map} must be a vector of names of rows or columns in \code{a}.
The names in the value are aggregated and inserted into the output with the name of the value.
For example \code{aggregation_map = list(new_row = c("r1", "r2"))}
will aggregate rows "r1" and "r2", delete rows "r1" and "r2", and insert a new row
whose name is "new_row" and whose value is the sum of rows "r1" and "r2'.

The values in the \code{aggregation_map} are interpreted as regular expressions, and
they are escaped using \code{Hmisc::escapeRegex()} prior to use.

Note that aggregation on one margin only will sort only the aggregated margin, because
the other margin is not guaranteed to have unique names.
}
\examples{
library(dplyr)
library(tibble)
m <- matrix(1:9, byrow = TRUE, nrow = 3, 
            dimnames = list(c("r2", "r1", "r1"), c("c2", "c1", "c1"))) \%>\% 
  setrowtype("rows") \%>\% setcoltype("cols")
# Aggregate all rows by establishing an aggregation map (`am`)
am <- list(new_row = c("r1", "r2"))
aggregate_byname(m, aggregation_map = am, margin = 1)
# aggregate_byname() also works with lists and in data frames
m1 <- matrix(42, nrow = 1, dimnames = list(c("r1"), c("c1")))
m2 <- matrix(1:4, byrow = TRUE, nrow = 2, 
             dimnames = list(c("a", "a"), c("a", "a")))
m3 <- matrix(1:9, byrow = TRUE, nrow = 3, 
             dimnames = list(c("r2", "r1", "r1"), c("c2", "c1", "c1")))
DF <- tibble(m = list(m1, m1, m1, m2, m2, m2, m3, m3, m3), 
             margin = list(1, 2, c(1,2), 1, 2, c(1, 2), 1, 2, c(1, 2))) \%>\% 
  mutate(
    aggregated = aggregate_byname(m, margin = margin), 
  )
m1
DF$aggregated[[1]] # by rows
DF$aggregated[[2]] # by cols
DF$aggregated[[3]] # by rows and cols
m2
DF$aggregated[[4]] # by rows
DF$aggregated[[5]] # by cols
DF$aggregated[[6]] # by rows and cols
m3
DF$aggregated[[7]] # by rows
DF$aggregated[[8]] # by cols
DF$aggregated[[9]] # by rows and cols
}
