% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast.R
\docType{methods}
\name{summary,Forecast-method}
\alias{summary,Forecast-method}
\title{Prints the summary of a Forecast object}
\usage{
\S4method{summary}{Forecast}(object)
}
\arguments{
\item{object}{Object of class Forecast}
}
\value{
A data frame showing a summary of fitted models.
}
\description{
Summarizes the fitted models estimated for predicting item values (e.g., demand, stock).
}
\examples{
data("Amount")
prediction = predictValue(data = Amount,
    value = "amount",
    item = "item",
    timestamp = "date",
    temporalAggregation = "week",
    timeUnitsAhead = 3)
summary(prediction)
}
\seealso{
\code{\link{predictValue}} \code{\link[=Forecast-class]{Forecast}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
