% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R.R
\name{R}
\alias{R}
\title{Rank of a Matrix}
\usage{
R(X)
}
\arguments{
\item{X}{a matrix}
}
\value{
rank of \code{X}
}
\description{
Returns the rank of a matrix \code{X}, using the QR decomposition, \code{\link{QR}}.
Included here as a simple function, because \code{rank} does something different
and it is not obvious what to use for matrix rank.
}
\examples{
M <- outer(1:3, 3:1)
M
R(M)

M <- matrix(1:9, 3, 3)
M
R(M)
# why rank=2?
echelon(M)

set.seed(1234)
M <- matrix(sample(1:9), 3, 3)
M
R(M)
}
\seealso{
\code{\link[base]{qr}}
}
