% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{Inverse}
\alias{Inverse}
\alias{inv}
\title{Inverse of a Matrix}
\usage{
Inverse(X, tol = sqrt(.Machine$double.eps), ...)
}
\arguments{
\item{X}{a square numeric matrix}

\item{tol}{tolerance for checking for 0 pivot}

\item{...}{other arguments passed on}
}
\value{
the inverse of \code{X}
}
\description{
Uses \code{\link{gaussianElimination}} to find the inverse of a square, non-singular matrix, \eqn{X}.
}
\details{
The method is purely didactic: The identity matrix, \eqn{I}, is appended to \eqn{X}, giving
\eqn{X | I}.  Applying Gaussian elimination gives \eqn{I | X^{-1}}, and the portion corresponding
to \eqn{X^{-1}} is returned.
}
\examples{
  A <- matrix(c(2, 1, -1,
               -3, -1, 2,
               -2,  1, 2), 3, 3, byrow=TRUE)
  Inverse(A)
  Inverse(A, verbose=TRUE, fractions=TRUE)
}
\author{
John Fox
}
