% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedMatingPlot.R
\name{plot3DScene}
\alias{plot3DScene}
\title{multi-dimensional visualization of mating scene object}
\usage{
plot3DScene(scene, dimension = "auto", sub = NULL, ycoord = "northing",
  xcoord = "easting", pch = 19, ...)
}
\arguments{
\item{scene}{a matingScene object}

\item{dimension}{what dimension(s) of the mating scene should be visualized. Possible dimensions are 't' for temporal, 's' for spatial, 'mt' for mating type, and 'auto' (the default). For dimension = 'auto', all dimensions represented in the mating scene object will be plotted.}

\item{sub}{a subset of the population to plot}

\item{ycoord}{y-axis coordinate system label}

\item{xcoord}{x-axis coordinate system label}

\item{pch}{point type, defaults to pch = 19, solid filled in circle. If pch = NULL, individuals will be labeled by their id.}

\item{...}{optional arguments for the plot function}
}
\value{
nothing
}
\description{
Visualize multiple dimensions of a mating scene
}
\examples{
pop <- simulateScene()
plot3DScene(pop)



}
\author{
Amy Waananen
}
\seealso{
see generic function \code{\link{points}} for values of \code{pch}
}

