% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat2r.R
\name{mat2r}
\alias{mat2r}
\title{mat2r}
\usage{
mat2r(inMat, pathOutR = "", funcConverters = NULL,
  dataConverters = NULL, verbose = 1)
}
\arguments{
\item{inMat}{A file path with the input Matlab / Octave code to be converted
or a character vector of the code that needs to be converted}

\item{pathOutR}{A file path with the desired output file location}

\item{funcConverters}{A list of function converters that the user wants to
use in this conversion made by \code{\link{makeFuncMaps}}}

\item{dataConverters}{A list of data converters that the user wants to 
use in this conversion made by \code{\link{makeSliceMap}} or
\code{\link{makeDataMap}}}

\item{verbose}{A number indicating the amount of messages that should be outputed.
\describe{
  \item{0}{No messages}
  \item{1}{A summary report of what happened in the conversion}
  \item{2}{The final code as a message as well as the summary report}
}}
}
\value{
A list containing the original code (named matCode) and the converted code (named rCode).
}
\description{
The top level driver function to call the converting functions and handle the
input and output.
}
\examples{
matIn <- c("function [ dat ] = xlsReadPretty(varargin)", 
 "  didThing = 1*3;",
 "  dat = didThing / 3;",
 "end")
 mat2r(matIn, verbose = 0)$rCode

# "xlsReadPretty <- function(...){" 
# "\\tvarargin <- list(...)"
# "  didThing <- 1*3"
# "  dat <- didThing / 3"
#"\\treturn(dat)"
#"}"
}
