% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{update_mass_props}
\alias{update_mass_props}
\title{Update mass properties}
\usage{
update_mass_props(df, target, sources, override = set_poi_conv_from_target)
}
\arguments{
\item{df}{A data frame  with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.}

\item{target}{The \code{id} value of the target row.}

\item{sources}{List of \code{id} values of the of the source rows.}

\item{override}{An override function, called as override(df, target, value). The default override sets the POI sign convention
of a computed aggregate to the \code{POIconv} column of the target row in the data frame.}
}
\value{
The updated data frame.
}
\description{
\code{update_mass_props()} updates mass properties for a specified target row from
specified source rows in a data frame.
}
\examples{
leaves <- names(igraph::neighbors(test_tree, "A.3", mode = "in"))
update_mass_props(test_table, "A.3", leaves)

}
