% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{date_from_partial}
\alias{date_from_partial}
\title{Partial dates}
\usage{
date_from_partial(
  x,
  format = "ymd",
  method = c("min", "max"),
  year_replacement = NA_integer_
)
}
\arguments{
\item{x}{A vector of dates written as characters}

\item{format}{Format order of the date (accepts only combinations of \code{'y'},
\code{'m'}, and \code{'d'})}

\item{method}{Method for reporting partial dates as either the earliest
possible date (\code{"min"}) or the latest possible date (\code{"max"}); dates with
missing days will be adjusted accordingly to the month and, if needed, the
leap year}

\item{year_replacement}{(Default: \code{NA_integer_}) If set, will use this as a
replacement for dates that contain missing years}
}
\value{
A vector of \code{Dates}
}
\description{
Derive a date vector from a partial date string
}
\details{
Takes a character as an argument and attempts to create a date object when
part of the date string is missing.
}
\examples{
x <- c("2020-12-17", NA_character_, "", "2020-12-UN", "2020-12-UN",
       "2019-Unknown-00", "UNK-UNK-UNK", "1991-02-UN", "    ",
       "2020January20")
data.frame(
  x = x,
  min = date_from_partial(x),
  max = date_from_partial(x, method = "max"),
  year = date_from_partial(x, year_replacement = 1900)
)
}
