% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na-assignment.R
\name{na_assignments}
\alias{na_assignments}
\alias{NA_at}
\alias{NA_if}
\alias{NA_in}
\alias{NA_out}
\title{NA at positions}
\usage{
NA_at(x, y, ...)

NA_if(x, y, ...)

NA_in(x, y, ...)

NA_out(x, y, ...)
}
\arguments{
\item{x}{A vector of values}

\item{y}{Either a suitable value (see \code{Details}) or a function which accepts
\code{x} as its first parameter and can return suitable values}

\item{...}{Additional values passed to \code{y} (if \code{y} is a function)}
}
\value{
\code{x} with assigned \code{NA} values
}
\description{
Converts select elements of a vector into \code{NA}s

This is how the end results are
\itemize{
\item \code{NA_at} and \code{NA_if} require a suitable index value (\code{x[y] <- NA})
\itemize{
\item \code{NA_at} expects \code{y} (or the result of function \code{y}) to be \code{integers}
\item \code{NA_if} expects \code{y} (or the result of function \code{y}) to be \code{logical}
}
\item \code{NA_in} and \code{NA_out} expect some values to match on
\itemize{
\item \code{NA_in} checks \code{x[x \%in\% y] <- NA}
\item \code{NA_out} checks \code{x[x \%out\% y] <- NA} (see \link{match_ext})
}
}
}
\details{
Convert specific values to NA
}
\examples{
let <- ordered(letters[1:5])
NA_at(let, c(1, 3, 5))   # [1] <NA> b    <NA> d    <NA>
NA_if(let, let <= "b")   # [1] <NA> <NA> c    d    e
NA_in(let, c("a", "c"))  # [1] <NA> b    <NA> d    e
NA_out(let, c("a", "c")) # [1] a    <NA> c    <NA> <NA>

}
\seealso{
Inspired by \code{\link[dplyr:na_if]{dplyr::na_if()}}
}
