% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-list.R
\name{merge_list}
\alias{merge_list}
\title{Merge lists}
\usage{
merge_list(x, y, keep = c("x", "y"), null = c("ignore", "drop", "keep")[1:2])
}
\arguments{
\item{x, y}{Lists to merge}

\item{keep}{When matching names are found, from which object should the
values be retained; \code{"x"} retains values from \code{x}, \code{"y"} retains values
from \code{y}.}

\item{null}{Method for handling \code{NULL} values.  When two values are passed,
they will be applied to \code{x} and \code{y} respectively.  When a single value is
passed, it will be applied to both \code{x} and \code{y}.
\itemize{
\item \code{"ignore"}: \code{NULL} values are ignored.  When passes to \code{x}, the \code{NULL}
values will be retained if they are not overridden by \code{y}.
\item \code{"drop"}: \code{NULL} values are dropped from merge and will not appear in the
output.
\item \code{"keep"}: \code{NULL} values are retained in the output and can override other
values.
}}
}
\description{
Merge lists with different or intersecting names
}
\examples{
x <- list(a = 1, b = 2,    c = NULL, d = NULL)
y <- list(a = 2, b = NULL, c = 3)

# compared to:
utils::modifyList(x, y)
utils::modifyList(x, y, keep.null = TRUE)

merge_list(x, y)
merge_list(x, y, keep = "y")
merge_list(x, y, null = "drop")
}
