% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_rank.R
\name{percentile_rank}
\alias{percentile_rank}
\title{Percentile rank}
\usage{
percentile_rank(x, times = NULL)
}
\arguments{
\item{x}{A vector of values to rank}

\item{times}{A vector of the number of times to repeat \code{x}}
}
\value{
The percentile rank of \code{x} between 0 and 1, exclusive
}
\description{
The bounds of the percentile rank are > 0 and < 1

A percentile rank here is the proportion of scores that are less than the
current score.

\deqn{PR = (c_L + 0.5 f_i) / N}

Where

\eqn{c_L} is the frequency of scores less than the score of interest

\eqn{f_i} is the frequency of the score of interest
}
\details{
Computes a percentile rank for each score in a set.
}
\examples{
percentile_rank(0:9)
x <- c(1, 2, 1, 7, 5, NA_integer_, 7, 10)
percentile_rank(x)

if (package_available("dplyr")) {
  dplyr::percent_rank(x)
}

# with times
percentile_rank(7:1, c(1, 0, 2, 2, 3, 1, 1))
}
