% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{utils-paste}
\alias{utils-paste}
\alias{paste_c}
\alias{paste_combine}
\alias{collapse0}
\title{Paste combine}
\usage{
paste_c(x, y, collate = TRUE, sep = "")

paste_combine(..., collate = TRUE, sep = "")

collapse0(..., sep = "")
}
\arguments{
\item{x, y, ...}{Vectors to paste and/or combine}

\item{collate}{Logical; \code{TRUE} prints out combinations in order of the first
vector elements then the next; otherwise reversed (see examples)}

\item{sep}{A character string to separate terms}
}
\value{
A \code{character} vector
}
\description{
Paste and combine
}
\examples{
x <- letters[1:5]
y <- 1:3
z <- month.abb[c(1, 12)]
paste_combine(x, y)
paste_combine(x, y, z)
paste_combine(x, y, z, sep = ".")
paste_combine(x, y, sep = "_")
paste_combine(x, y, collate = FALSE)
collapse0(list(1:3, letters[1:3]), 5:7, letters[5:7])
collapse0(1:3, letters[5:7], sep = "_")
}
