% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communityCondition.R
\name{communityCondition}
\alias{communityCondition}
\title{Calculates Fulton's Condition Index for the community}
\usage{
communityCondition(X_length, groups, species.table = NULL, LenWt.table,
  years)
}
\arguments{
\item{X_length}{A dataframe of fishery independent data derived from research
vessel survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, \code{LENGTH}, and \code{ABUNDANCE}. \code{YEAR} indicates
the year the observation was recorded, \code{ID} is an area code indicating
where the observation was recorded, and \code{SPECIES} is a numeric code
indicating the species sampled. \code{LENGTH} is the length class (cm) and
\code{ABUNDANCE} is the corresponding abundance at length (stratified and
corrected for catchability as required). Species for which there are no
length data should be assigned \code{LENGTH = -99}. These observations are
removed by the function.}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{LenWt.table}{A table of annual length at weight data with 5 columns.
\code{YEAR}, \code{ID}, and \code{SPECIES} are as described in
\code{X_length}. \code{LENGTH} is fish length at the corresponding
\code{WEIGHT} (fish weight).}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
 column \code{CCondition_group} for each entry in \code{groups}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 value is assigned \code{NA}.
}
\description{
This function calculates Fulton's Condition Index for \eqn{j}
 areas and \eqn{i} years.
}
\details{
Fulton's Condition Index (\eqn{K}): \deqn{K = \Sigma(K_j *
 A_j)/\Sigma A_j} where the sum is over all species, \eqn{j}, \eqn{A_j} is
 the abundance of species \eqn{j}, and \deqn{K_j = 100*W_j/L_j^3} where
 \eqn{W_j} is the mean weight at length \eqn{L} for species \eqn{j} (Ricker,
 1975).
}
\examples{
# Compile data
data(X_length)
data(species.table)
data(Length_Weight)

# Species groups of interest
condition.groups <- c("FINFISH", "LBENTHIVORE", "PISCIVORE", "PLANKTIVORE")

# Calculate indicators
communityCondition(X_length, LenWt.table = Length_Weight, groups = condition.groups,
   species.table = species.table, years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 DFO. 2003. State of the Eastern Scotian Shelf ecosystem. Dartmouth, Nova
 Scotia

 Choi JS, Frank KT, Petrie BD, Leggett WC. 2005. Integrated Assessment of a
 Large Marine Ecosystem: a case study of the devolution of the Eastern
 Scotian Shelf, Canada. Oceanogr Mar Biol An Annu Rev 43:47–67

 Ricker, W. E. 1975. Computation and interpretation of biological statistics
 of fish populations. Bulletin of the Fisheries Research Board of Canada
 191:1-382.
}
\seealso{
Other ecosystem structure and function indicators: \code{\link{allStructure}},
  \code{\link{biomassRatio}},
  \code{\link{largeFishIndicator}},
  \code{\link{largeSpeciesIndicator}},
  \code{\link{meanTLCommunity}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{ecosystem structure and function indicators}
