test_that("padding with interactions", {
    skip_if_not_installed("insight", minimum_version = "0.14.4.1")
    dat <- read.csv("https://vincentarelbundock.github.io/Rdatasets/csv/ggplot2movies/movies.csv")
    dat$style <- ifelse(dat$Action == 1, "Action", "Other")
    dat$style <- ifelse(dat$Comedy == 1, "Comedy", dat$style)
    dat$style <- ifelse(dat$Drama == 1, "Drama", dat$style)
    dat$style <- factor(dat$style)
    dat$certified_fresh <- dat$rating >= 8
    dat <- dat[dat$length < 240,]
    mod <- glm(certified_fresh ~ length * style, data = dat, family = binomial)
    res <- predictions(mod, type = c("response", "link"))
    expect_predictions(res, n_row = 2)
})
