% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predict.R, R/methods_MASS.R,
%   R/methods_crch.R, R/methods_nnet.R
\name{get_predict}
\alias{get_predict}
\alias{get_predict.default}
\alias{get_predict.polr}
\alias{get_predict.crch}
\alias{get_predict.multinom}
\title{Get predicted values from a model object (internal function)}
\usage{
get_predict(model, newdata, type, ...)

\method{get_predict}{default}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{polr}(
  model,
  newdata = insight::get_data(model),
  type = "response",
  group_name = "1",
  ...
)

\method{get_predict}{crch}(model, newdata = NULL, type = "location", ...)

\method{get_predict}{multinom}(
  model,
  newdata = insight::get_data(model),
  type = "response",
  group_name = "1",
  ...
)
}
\arguments{
\item{model}{Model object}

\item{newdata}{A dataset over which to compute marginal effects. \code{NULL} uses
the original data used to fit the model.}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A vector of predicted values of length equal to the number of rows
in \code{newdata}. For models with multi-level outcomes (e.g., multinomial
logit), this function returns a matrix of predicted values with column names
equal to each of the levels/groups.
}
\description{
Get predicted values from a model object (internal function)
}
\keyword{internal}
