% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_line_layer}
\alias{add_line_layer}
\title{Add a line layer to a map}
\usage{
add_line_layer(
  map,
  id,
  source,
  source_layer = NULL,
  line_blur = NULL,
  line_color = NULL,
  line_dasharray = NULL,
  line_gap_width = NULL,
  line_offset = NULL,
  line_opacity = NULL,
  line_pattern = NULL,
  line_sort_key = NULL,
  line_translate = NULL,
  line_translate_anchor = "map",
  line_width = NULL,
  visibility = "visible",
  slot = NULL,
  min_zoom = NULL,
  max_zoom = NULL,
  popup = NULL,
  tooltip = NULL,
  hover_options = NULL,
  before_id = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{id}{A unique ID for the layer.}

\item{source}{The ID of the source, alternatively an sf object (which will be converted to a GeoJSON source) or a named list that specifies \code{type} and \code{url} for a remote source.}

\item{source_layer}{The source layer (for vector sources).}

\item{line_blur}{Amount to blur the line.}

\item{line_color}{The color with which the line will be drawn.}

\item{line_dasharray}{Specifies the lengths of the alternating dashes and gaps that form the dash pattern.}

\item{line_gap_width}{The width of the gap between a dashed line's individual dashes.}

\item{line_offset}{The line's offset.}

\item{line_opacity}{The opacity at which the line will be drawn.}

\item{line_pattern}{Name of image in sprite to use for drawing image fills.}

\item{line_sort_key}{Sorts features in ascending order based on this value.}

\item{line_translate}{The geometry's offset. Values are \code{c(x, y)} where negatives indicate left and up.}

\item{line_translate_anchor}{Controls the frame of reference for \code{line-translate}.}

\item{line_width}{Stroke thickness.}

\item{visibility}{Whether this layer is displayed.}

\item{slot}{An optional slot for layer order. Only available when using the Mapbox Standard style.}

\item{min_zoom}{The minimum zoom level for the layer.}

\item{max_zoom}{The maximum zoom level for the layer.}

\item{popup}{A column name containing information to display in a popup on click.  Columns containing HTML will be parsed.}

\item{tooltip}{A column name containing information to display in a tooltip on hover. Columns containing HTML will be parsed.}

\item{hover_options}{A named list of options for highlighting features in the layer on hover.}

\item{before_id}{The name of the layer that this layer appears "before", allowing you to insert layers below other layers in your basemap (e.g. labels).}
}
\value{
The modified map object with the new line layer added.
}
\description{
Add a line layer to a map
}
\examples{
\dontrun{
library(mapgl)
library(tigris)

loving_roads <- roads("TX", "Loving")

maplibre(style = maptiler_style("backdrop")) |>
  fit_bounds(loving_roads) |>
  add_line_layer(
    id = "tracks",
    source = loving_roads,
    line_color = "navy",
    line_opacity = 0.7
  )
}
}
