% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_layer}
\alias{add_layer}
\title{Add a layer to a map from a source}
\usage{
add_layer(
  map,
  id,
  type = "fill",
  source,
  source_layer = NULL,
  paint = list(),
  layout = list(),
  slot = NULL,
  min_zoom = NULL,
  max_zoom = NULL,
  popup = NULL,
  tooltip = NULL,
  hover_options = NULL,
  before_id = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl()} or \code{maplibre()} functions.}

\item{id}{A unique ID for the layer.}

\item{type}{The type of the layer (e.g., "fill", "line", "circle").}

\item{source}{The ID of the source, alternatively an sf object (which will be converted to a GeoJSON source) or a named list that specifies \code{type} and \code{url} for a remote source.}

\item{source_layer}{The source layer (for vector sources).}

\item{paint}{A list of paint properties for the layer.}

\item{layout}{A list of layout properties for the layer.}

\item{slot}{An optional slot for layer order.}

\item{min_zoom}{The minimum zoom level for the layer.}

\item{max_zoom}{The maximum zoom level for the layer.}

\item{popup}{A column name containing information to display in a popup on click.  Columns containing HTML will be parsed.}

\item{tooltip}{A column name containing information to display in a tooltip on hover. Columns containing HTML will be parsed.}

\item{hover_options}{A named list of options for highlighting features in the layer on hover.}

\item{before_id}{The name of the layer that this layer appears "before", allowing you to insert layers below other layers in your basemap (e.g. labels).}
}
\value{
The modified map object with the new layer added.
}
\description{
In many cases, you will use \code{add_layer()} internal to other layer-specific functions in mapgl. Advanced users will want to use \code{add_layer()} for more fine-grained control over the appearance of their layers.
}
\examples{
\dontrun{
# Load necessary libraries
library(mapgl)
library(tigris)

# Load geojson data for North Carolina tracts
nc_tracts <- tracts(state = "NC", cb = TRUE)

# Create a Mapbox GL map
map <- mapboxgl(
 style = mapbox_style("light"),
 center = c(-79.0193, 35.7596),
 zoom = 7
)

# Add a source and fill layer for North Carolina tracts
map \%>\%
 add_source(
   id = "nc-tracts",
   data = nc_tracts
 ) \%>\%
 add_layer(
   id = "nc-layer",
   type = "fill",
   source = "nc-tracts",
   paint = list(
     "fill-color" = "#888888",
     "fill-opacity" = 0.4
   )
 )
}
}
