% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_simplified.R
\name{esp_get_simpl_prov}
\alias{esp_get_simpl_prov}
\alias{esp_get_simpl_ccaa}
\title{Get a simplified map of provinces and autonomous communities of Spain}
\source{
INE: PC_Axis files
}
\usage{
esp_get_simpl_prov(
  prov = NULL,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)

esp_get_simpl_ccaa(
  ccaa = NULL,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{prov}{A vector of names and/or codes for provinces
or \code{NULL} to get all the provinces. See \strong{Details}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{ccaa}{A vector of names and/or codes for autonomous communities
or \code{NULL} to get all the autonomous communities. See \strong{Details}.}
}
\value{
A \pkg{sf} POLYGON object.
}
\description{
Loads a simplified map (\pkg{sf} object) with the boundaries of the provinces or
autonomous communities of Spain, as provided by the \strong{INE} (Instituto
Nacional de Estadistica).
}
\details{
Results are provided \strong{without CRS}, as provided on source.

You can use and mix names, ISO codes, "codauto"/"cpro" codes (see
\link{esp_codelist}) and NUTS codes of different levels.

When using a code corresponding of a higher level (e.g.
\code{esp_get_simpl_prov("Andalucia")}) all the corresponding units of that level
are provided (in this case , all the provinces of Andalucia).
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
prov_simp <- esp_get_simpl_prov()

library(ggplot2)

ggplot(prov_simp) +
  geom_sf(aes(fill = ine.ccaa.name)) +
  labs(fill = "CCAA")

# Provs of Single CCAA

and_simple <- esp_get_simpl_prov("Andalucia")

ggplot(and_simple) +
  geom_sf()

# CCAAs

ccaa_simp <- esp_get_simpl_ccaa()

ggplot(ccaa_simp) +
  geom_sf() +
  geom_sf_text(aes(label = ine.ccaa.name), check_overlap = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=esp_get_hex_prov]{esp_get_hex_prov()}}, \code{\link[=esp_get_hex_ccaa]{esp_get_hex_ccaa()}}

Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()}
}
\concept{political}
