% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_generate.R
\name{make_stochastic}
\alias{make_stochastic}
\alias{generate_smallworld}
\alias{generate_scalefree}
\alias{generate_fire}
\alias{generate_islands}
\alias{generate_citations}
\title{Making networks with a stochastic element}
\usage{
generate_smallworld(n, p = 0.05, directed = FALSE, width = 2)

generate_scalefree(n, p = 1, directed = FALSE)

generate_fire(n, contacts = 1, their_out = 0, their_in = 1, directed = FALSE)

generate_islands(n, islands = 2, p = 0.5, bridges = 1, directed = FALSE)

generate_citations(
  n,
  ties = sample(1:4, 1),
  agebins = max(1, n/10),
  directed = FALSE
)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A manynet-compatible object,
a network of the same dimensions will be created.
}}

\item{p}{Power of the preferential attachment, default is 1.}

\item{directed}{Whether to generate network as directed. By default FALSE.}

\item{width}{Integer specifying the width of the ring,
breadth of the branches, or maximum extent of the neighbourbood.}

\item{contacts}{Number of contacts or ambassadors chosen from among existing
nodes in the network.
By default 1.
See \code{igraph::sample_forestfire()}.}

\item{their_out}{Probability of tieing to a contact's outgoing ties.
By default 0.}

\item{their_in}{Probability of tieing to a contact's incoming ties.
By default 1.}

\item{islands}{Number of islands or communities to create.
By default 2.
See \code{igraph::sample_islands()} for more.}

\item{bridges}{Number of bridges between islands/communities.
By default 1.}

\item{ties}{Number of ties to add per new node.
By default a uniform random sample from 1 to 4 new ties.}

\item{agebins}{Number of aging bins.
By default either \eqn{\frac{n}{10}} or 1,
whichever is the larger.
See \code{igraphr::sample_last_cit()} for more.}
}
\value{
By default a \code{tbl_graph} object is returned,
but this can be coerced into other types of objects
using \code{as_edgelist()}, \code{as_matrix()},
\code{as_tidygraph()}, or \code{as_network()}.

By default, all networks are created as undirected.
This can be overruled with the argument \code{directed = TRUE}.
This will return a directed network in which the arcs are
out-facing or equivalent.
This direction can be swapped using \code{to_redirected()}.
In two-mode networks, the directed argument is ignored.
}
\description{
These functions are similar to the \verb{create_*} functions,
but include some element of randomisation.
They are particularly useful for creating a distribution of networks
for exploring or testing network properties.
\itemize{
\item \code{generate_smallworld()} generates a small-world structure via ring rewiring at some probability.
\item \code{generate_scalefree()} generates a scale-free structure via preferential attachment at some probability.
\item \code{generate_fire()} generates a forest fire model.
\item \code{generate_islands()} generates an islands model.
\item \code{generate_citations()} generates a citations model.
}

These functions can create either one-mode or two-mode networks.
To create a one-mode network, pass the main argument \code{n} a single integer,
indicating the number of nodes in the network.
To create a two-mode network, pass \code{n} a vector of \emph{two} integers,
where the first integer indicates the number of nodes in the first mode,
and the second integer indicates the number of nodes in the second mode.
As an alternative, an existing network can be provided to \code{n}
and the number of modes, nodes, and directedness will be inferred.
}
\examples{
graphr(generate_smallworld(12, 0.025))
graphr(generate_smallworld(12, 0.25))
graphr(generate_scalefree(12, 0.25))
graphr(generate_scalefree(12, 1.25))
generate_fire(10)
generate_islands(10)
generate_citations(10)
}
\references{
\subsection{On small-world networks}{

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks.”
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}.
}

\subsection{On scale-free networks}{

Barabasi, Albert-Laszlo, and Reka Albert. 1999.
“Emergence of Scaling in Random Networks.”
\emph{Science} 286(5439):509–12.
\doi{10.1126/science.286.5439.509}.
}

\subsection{On the forest-fire model}{

Leskovec, Jure, Jon Kleinberg, and Christos Faloutsos. 2007.
"\href{https://www.cs.cmu.edu/~jure/pubs/powergrowth-tkdd.pdf}{Graph evolution: Densification and shrinking diameters}".
\emph{ACM transactions on Knowledge Discovery from Data}, 1(1): 2-es.
}
}
\seealso{
Other makes: 
\code{\link{make_cran}},
\code{\link{make_create}},
\code{\link{make_ego}},
\code{\link{make_explicit}},
\code{\link{make_learning}},
\code{\link{make_motifs}},
\code{\link{make_play}},
\code{\link{make_random}},
\code{\link{make_read}},
\code{\link{make_write}}
}
\concept{makes}
