% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prod.R
\name{get_prod}
\alias{get_prod}
\title{Product Terms (if Any)
Along a Path}
\usage{
get_prod(
  x,
  y,
  operator = ":",
  fit = NULL,
  est = NULL,
  data = NULL,
  expand = FALSE
)
}
\arguments{
\item{x}{Character. Variable name.}

\item{y}{Character. Variable name.}

\item{operator}{Character. The string
used to indicate a product term.
Default is \code{":"}, used in both \code{\link[=lm]{lm()}}
and \code{\link[lavaan:sem]{lavaan::sem()}} for observed
variables.}

\item{fit}{The fit object. Currently
only supports a
\link[lavaan:lavaan-class]{lavaan::lavaan} object.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[semTools:runMI]{semTools::runMI()}} or
its wrapper, such as \code{\link[semTools:runMI]{semTools::sem.mi()}}.}

\item{est}{The output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}. If
\code{NULL}, the default, it will be
generated from \code{fit}. If supplied,
\code{fit} will ge ignored.}

\item{data}{Data frame (optional). If
supplied, it will be used to identify
the product terms.}

\item{expand}{Whether products of
more than two terms will be searched.
\code{FALSE} by default.}
}
\value{
If at least one product term is found,
it returns a list with these elements:
\itemize{
\item \code{prod}: The names of the product terms
found.
\item \code{b}: The coefficients of these
product terms.
\item \code{w}: The variable, other than
\code{x}, in each product term.
\item \code{x}: The \code{x}-variable, that is,
where the path starts.
\item \code{y}: The \code{y}-variable, that is,
where the path ends.
}

It returns \code{NA} if no product term
is found along the path.
}
\description{
Identify the product
term(s), if any, along a path in
a model and return the term(s),
with the variables involved and
the coefficient(s) of the term(s).
}
\details{
This function is used
by several functions in \code{manymome}
to identify product terms along
a path. If possible, this is done
by numerically checking whether a
column in a dataset is the product
of two other columns. If not possible
(e.g., the "product term" is the
"product" of two latent variables,
formed by the products of indicators),
then it requires the user to specify
an operator.

The detailed workflow of this function
can be found in the
article \url{https://sfcheung.github.io/manymome/articles/get_prod.html}

This function is not intended to be used
by users. It is exported such that
advanced users or developers can use
it.
}
\examples{

dat <- modmed_x1m3w4y1
library(lavaan)
mod <-
"
m1 ~ x   + w1 + x:w1
m2 ~ m1  + w2 + m1:w2
m3 ~ m2
y  ~ m3  + w4 + m3:w4 + x + w3 + x:w3 + x:w4
"
fit <- sem(model = mod,
           data = dat,
           meanstructure = TRUE,
           fixed.x = FALSE)

# One product term
get_prod(x = "x", y = "m1", fit = fit)
# Two product terms
get_prod(x = "x", y = "y", fit = fit)
# No product term
get_prod(x = "m2", y = "m3", fit = fit)

}
