% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_indirect_list.R
\name{coef.indirect_list}
\alias{coef.indirect_list}
\title{Extract the Indirect Effects
from a 'indirect_list' Object}
\usage{
\method{coef}{indirect_list}(object, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.}

\item{...}{Optional arguments.
Ignored by the function.}
}
\value{
A numeric vector of the
indirect effects.
}
\description{
Return the estimates of
the indirect effects in the output of
\code{\link[=many_indirect_effects]{many_indirect_effects()}}.
}
\details{
It extracts the estimates
in each 'indirect'-class object
in the list.

If standardized effect is requested
when calling \code{\link[=many_indirect_effects]{many_indirect_effects()}},
the effects
returned are also standardized.
}
\examples{

library(lavaan)
data(data_serial_parallel)
mod <-
"
m11 ~ x + c1 + c2
m12 ~ m11 + x + c1 + c2
m2 ~ x + c1 + c2
y ~ m12 + m2 + m11 + x + c1 + c2
"
fit <- sem(mod, data_serial_parallel,
           fixed.x = FALSE)
# All indirect paths from x to y
paths <- all_indirect_paths(fit,
                           x = "x",
                           y = "y")
paths
# Indirect effect estimates
out <- many_indirect_effects(paths,
                             fit = fit)
out
coef(out)


}
\seealso{
\code{\link[=many_indirect_effects]{many_indirect_effects()}}
}
