% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_data.R
\name{transmutate}
\alias{transmutate}
\title{Drop only columns used in formula}
\source{
https://stackoverflow.com/questions/51428156/dplyr-mutate-transmute-drop-only-the-columns-used-in-the-formula
}
\usage{
transmutate(.data, ...)
}
\arguments{
\item{.data}{Data frame to pass to the function}

\item{...}{Variables to pass to the function}
}
\value{
Data frame with mutated variables
and none of the variables used in the mutations,
but, unlike \code{dplyr::transmute()}, all other unnamed variables.
}
\description{
A function between dplyr's transmute and mutate
}
\examples{
\donttest{
pluck(emperors, "Wikipedia")
transmutate(emperors$Wikipedia, Beginning = Begin)
}
}
