% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_bootstrap.R
\name{mp_bootstrap}
\alias{mp_bootstrap}
\title{Compute bootstrap distributions for scaling functions}
\usage{
mp_bootstrap(data, fun = rile,
  col_filter = "per((\\\\d{3}(_\\\\d)?)|\\\\d{4}|(uncod))",
  statistics = list(sd), N = 1000, ...)
}
\arguments{
\item{data}{A data.frame with cases to be scaled and bootstrapped}

\item{fun}{function of a data row the bootstraped distribution of which is of interest}

\item{col_filter}{Regular expression matching the column names that should be
permuted for the resampling (usually and by default ther per variables)}

\item{statistics}{A list (!) of statistics to be computed from the bootstrap
distribution; defaults to standard deviation (\code{\link{sd}}). Must be
functions or numbers, where numbers are interpreted as quantiles.}

\item{N}{number of resamples to use for bootstrap distribution}

\item{...}{more arguments passed on to \code{fun}}
}
\description{
Bootstrapping of distributions of scaling functions as described by
Benoit, Mikhaylov, and Laver (2009). Given a dataset with percentages of CMP
categories, for each case the distribution of categories is resampled from
a multinomial distribution and the scaling function computed for the resampled
values. Arbitrary statistics of the resulting bootstrap distribution can be
returned, such as standard deviation, quantiles, etc.
}
\references{
Benoit, K., Laver, M., & Mikhaylov, S. (2009). Treating Words as Data with Error: Uncertainty in Text Statements of Policy Positions. American Journal of Political Science, 53(2), 495-513. http://doi.org/10.1111/j.1540-5907.2009.00383.x
}

