% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pipeline.R
\name{Pipeline}
\alias{Pipeline}
\title{Pipeline visualisations}
\description{
A Pipeline object is automatically constructed as calls to
\verb{make_*()} are made. It stores the relationships between targets,
dependencies, and sources.
}
\seealso{
Other pipeline: 
\code{\link{pipeline-accessors}},
\code{\link{pipeline-vis}}
}
\concept{pipeline}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{edges}}{A data frame}

\item{\code{nodes}}{A data frame}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-add_source_segment}{\code{Pipeline$add_source_segment()}}
\item \href{#method-add_recipe_segment}{\code{Pipeline$add_recipe_segment()}}
\item \href{#method-style_nodes}{\code{Pipeline$style_nodes()}}
\item \href{#method-print}{\code{Pipeline$print()}}
\item \href{#method-save}{\code{Pipeline$save()}}
\item \href{#method-clone}{\code{Pipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_source_segment"></a>}}
\if{latex}{\out{\hypertarget{method-add_source_segment}{}}}
\subsection{Method \code{add_source_segment()}}{
Add a pipeline segment corresponding to a \code{make_with_source()}
call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$add_source_segment(source, targets, dependencies, packages)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{The path to an R script which makes the \code{targets}}

\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the
\code{targets} depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_recipe_segment"></a>}}
\if{latex}{\out{\hypertarget{method-add_recipe_segment}{}}}
\subsection{Method \code{add_recipe_segment()}}{
Add a pipeline segment corresponding to a \code{make_with_recipe()}
call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$add_recipe_segment(recipe, targets, dependencies, packages)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recipe}}{A character vector containing a deparsed expression, which
would make the \code{targets} if evaluated.}

\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the
\code{targets} depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-style_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-style_nodes}{}}}
\subsection{Method \code{style_nodes()}}{
Style pipeline nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$style_nodes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Display pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments (other than \code{nodes} and \code{edges}) to pass to
\code{visNetwork::visNetwork()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
Save pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$save(file, selfcontained = TRUE, background = "white", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File to save HTML into}

\item{\code{selfcontained}}{Whether to save the HTML as a single self-contained
file (with external resources base64 encoded) or a file with external
resources placed in an adjacent directory.}

\item{\code{background}}{Text string giving the html background color of the
widget. Defaults to white.}

\item{\code{...}}{Arguments (other than \code{nodes} and \code{edges}) to pass to
\code{visNetwork::visNetwork()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
