% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_km.R
\name{kmplot}
\alias{kmplot}
\title{Kaplan Meier (KM) plot function for anchored and unanchored cases}
\usage{
kmplot(
  weights_object,
  tte_ipd,
  tte_pseudo_ipd,
  trt_ipd,
  trt_agd,
  trt_common = NULL,
  normalize_weights = FALSE,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  km_conf_type = "log-log",
  km_layout = c("all", "by_trial", "by_arm"),
  ...
)
}
\arguments{
\item{weights_object}{an object returned by \code{estimate_weight}}

\item{tte_ipd}{a data frame of individual patient data (IPD) of internal trial, contain at least \code{"USUBJID"},
\code{"EVENT"}, \code{"TIME"} columns and a column indicating treatment assignment}

\item{tte_pseudo_ipd}{a data frame of pseudo IPD by digitized KM curves of external trial (for time-to-event
endpoint), contain at least \code{"EVENT"}, \code{"TIME"}}

\item{trt_ipd}{a string, name of the interested investigation arm in internal trial \code{dat_igd} (real IPD)}

\item{trt_agd}{a string, name of the interested investigation arm in external trial \code{dat_pseudo} (pseudo IPD)}

\item{trt_common}{a string, name of the common comparator in internal and external trial, by default is NULL,
indicating unanchored case}

\item{normalize_weights}{logical, default is \code{FALSE}. If \code{TRUE},
\code{scaled_weights} (normalized weights) in \code{weights_object$data} will be used.}

\item{trt_var_ipd}{a string, column name in \code{tte_ipd} that contains the treatment assignment}

\item{trt_var_agd}{a string, column name in \code{tte_pseudo_ipd} that contains the treatment assignment}

\item{km_conf_type}{a string, pass to \code{conf.type} of \code{survfit}}

\item{km_layout}{a string, only applicable for unanchored case (\code{trt_common = NULL}), indicated the desired
layout of output KM curve.}

\item{...}{other arguments in \code{basic_kmplot}}
}
\value{
In unanchored case, a KM plot with risk set table. In anchored case, depending on \code{km_layout},
\itemize{
\item if "by_trial", 2 by 1 plot, first all KM curves (incl. weighted) in IPD trial, and then KM curves in AgD
trial, with risk set table.
\item if "by_arm", 2 by 1 plot, first KM curves of \code{trt_agd} and  \code{trt_ipd} (with and without weights),
and then KM curves of \code{trt_common} in AgD trial and IPD trial (with and without weights). Risk set table is
appended.
\item if "all", 2 by 2 plot, all plots in "by_trial" and "by_arm" without risk set table appended.
}
}
\description{
It is wrapper function of \code{basic_kmplot}. The argument setting is similar to \code{maic_anchored} and
\code{maic_unanchored}, and it is used in those two functions.
}
\examples{
# unanchored example using kmplot
data(weighted_sat)
data(adtte_sat)
data(pseudo_ipd_sat)

kmplot(
  weights_object = weighted_sat,
  tte_ipd = adtte_sat,
  tte_pseudo_ipd = pseudo_ipd_sat,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_name = "Overall Survival",
  trt_ipd = "A",
  trt_agd = "B",
  trt_common = NULL,
  km_conf_type = "log-log",
  time_scale = "month",
  time_grid = seq(0, 20, by = 2),
  use_colors = NULL,
  use_line_types = NULL,
  use_pch_cex = 0.65,
  use_pch_alpha = 100
)
# anchored example using kmplot
data(weighted_twt)
data(adtte_twt)
data(pseudo_ipd_twt)

# plot by trial
kmplot(
  weights_object = weighted_twt,
  tte_ipd = adtte_twt,
  tte_pseudo_ipd = pseudo_ipd_twt,
  trt_ipd = "A",
  trt_agd = "B",
  trt_common = "C",
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_name = "Overall Survival",
  km_conf_type = "log-log",
  km_layout = "by_trial",
  time_scale = "month",
  time_grid = seq(0, 20, by = 2),
  use_colors = NULL,
  use_line_types = NULL,
  use_pch_cex = 0.65,
  use_pch_alpha = 100
)

# plot by arm
kmplot(
  weights_object = weighted_twt,
  tte_ipd = adtte_twt,
  tte_pseudo_ipd = pseudo_ipd_twt,
  trt_ipd = "A",
  trt_agd = "B",
  trt_common = "C",
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_name = "Overall Survival",
  km_conf_type = "log-log",
  km_layout = "by_arm",
  time_scale = "month",
  time_grid = seq(0, 20, by = 2),
  use_colors = NULL,
  use_line_types = NULL,
  use_pch_cex = 0.65,
  use_pch_alpha = 100
)

# plot all
kmplot(
  weights_object = weighted_twt,
  tte_ipd = adtte_twt,
  tte_pseudo_ipd = pseudo_ipd_twt,
  trt_ipd = "A",
  trt_agd = "B",
  trt_common = "C",
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_name = "Overall Survival",
  km_conf_type = "log-log",
  km_layout = "all",
  time_scale = "month",
  time_grid = seq(0, 20, by = 2),
  use_colors = NULL,
  use_line_types = NULL,
  use_pch_cex = 0.65,
  use_pch_alpha = 100
)
}
