% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.SpatVector.R
\name{as.SpatVector}
\alias{as.SpatVector}
\title{as.SpatVector}
\usage{
as.SpatVector(x)
}
\arguments{
\item{x}{MAgPIE object}
}
\value{
A SpatVector object
}
\description{
Convert magclass object to a SpatVector object. Requires the terra package and
requires the magclass object to provide the geometry of the spatial entities
as "geometry" attribute in "WKT" format. (see object "m" in example).
}
\examples{

if (requireNamespace("terra", quietly = TRUE)) {
   r <- terra::rast(ncols = 360, nrows = 180, nl = 4)
   r[85:89, 176:179] <- (1:20 \%*\% t(1:4))
   r[15:19, 76:79] <-   (10 + 1:20 \%*\% t(1:4))
   names(r) <- c("y2000..bla", "y2001..bla", "y2000..blub", "y2001..blub")
   v <- terra::as.polygons(r)
   m <- as.magpie(v)
   attr(m, "geometry")
   attr(m, "crs")
   v2 <- as.SpatVector(m)
}
}
\seealso{
\code{\link{as.SpatRaster}}
}
\author{
Jan Philipp Dietrich
}
