% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pipelines.R
\name{check_pipelines}
\alias{check_pipelines}
\title{Check which pipelines are scheduled to run and when next pipelines will run}
\usage{
check_pipelines(
  orch_unit,
  orch_n,
  pipeline_unit,
  pipeline_n,
  check_datetime,
  pipeline_datetime,
  pipeline_hours = 0:23,
  pipeline_days_of_week = 1:7,
  pipeline_days_of_month = 1:31,
  pipeline_months = 1:12
)
}
\arguments{
\item{orch_unit}{unit of time for the orchestrator}

\item{orch_n}{number of units for the orchestrator}

\item{pipeline_unit}{unit for the pipeline frequency}

\item{pipeline_n}{number of units for the pipeline frequency}

\item{check_datetime}{datetime against which to check the running of pipelines (default is current system time in UTC)}

\item{pipeline_datetime}{datetime of the first time the pipeline is to run}

\item{pipeline_hours}{vector of integers [0-23] corresponding to hours of day for the pipeline to run}

\item{pipeline_days_of_week}{vector of integers [1-7] corresponding to days of week for the pipeline to run (1 = Sunday)}

\item{pipeline_days_of_month}{vector of integers [1-31] corresponding to days of month for the pipeline to run}

\item{pipeline_months}{vector of integers [1-12] corresponding to months of year for the pipeline to run}
}
\value{
list
}
\description{
Check which pipelines are scheduled to run and when next pipelines will run
}
