% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_name_standards}
\alias{check_name_standards}
\title{Assess variable names in a data dictionary for non-standard formats}
\usage{
check_name_standards(var_names)
}
\arguments{
\item{var_names}{A character vector of names.}
}
\value{
A tibble providing non-standard names across a vector.
}
\description{
Generates a tibble report of any variable names that are not compatible in
Maelstrom Research ecosystem, including Opal.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
The user must provide element which respect a certain structure to work with
the functions of the package or its environment (Maelstrom and/or
Obiba suite). In addition, any element may be compatible with Maelstrom
Research ecosystem, including Opal, and its content can be evaluated
accordingly, such as naming convention restriction, columns like 'valueType'
and 'label(:xx)' and/or any taxonomy provided.
}
\examples{
{

# use DEMO_files provided by the package

check_name_standards(c("coucou", "cou cou", "$coucou",NA))
check_name_standards(
 DEMO_files$`dd_TOKYO_format_maelstrom_tagged - ERROR`$Variables$name)

}

}
