% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dataset_functions.R
\name{as_dossier}
\alias{as_dossier}
\title{Validate and coerce an object to dossier format}
\usage{
as_dossier(object)
}
\arguments{
\item{object}{A potential dossier to be coerced.}
}
\value{
A list of tibble(s), each of them identifying datasets in a dossier.
}
\description{
Confirms that the input object is a valid dossier and returns it as a dossier
with the appropriate madshapR::class attribute. This function mainly helps
validate input within other functions of the package but could be used to
check if a dossier is valid.
}
\details{
A dossier must be a named list containing at least one data frame or
data frame extension (e.g. a tibble), each of them being datasets.
The name of each tibble will be use as the reference name of the dataset.
}
\examples{
{

# use DEMO_files provided by the package
library(stringr)

###### Example 1: a dataset list is a dossier by definition.
dossier <- 
  as_dossier(DEMO_files[str_detect(names(DEMO_files),"dataset")])
   
###### Example 2: any list of data frame (or tibble) can be a dossier by 
# definition.
as_dossier(list(dataset_1 = iris, dataset_2 = mtcars))

}

}
\seealso{
For a better assessment, please use \code{\link[=dataset_evaluate]{dataset_evaluate()}}.
}
