% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliForestSteppe.R
\name{cliForestSteppeGrid}
\alias{cliForestSteppeGrid}
\title{Forest-Steppe Models}
\usage{
cliForestSteppeGrid(
  rs.temp,
  rs.prec,
  rs.bsdf = NULL,
  rl.elv = NULL,
  sc.year = 2000,
  aprchTEMP = c("hip", "tsi", "const"),
  aprchBSDF = c("hip", "const"),
  dvTEMP = rep(0.7, 12),
  verbose = FALSE,
  filename = "",
  ...
)
}
\arguments{
\item{rs.temp}{multi-layer Raster* object with one-year time series of monthly mean air temperature (in °C)}

\item{rs.prec}{multi-layer Raster* object with one-year time series of monthly precipitation sum (in mm)}

\item{rs.bsdf}{multi-layer Raster* object with one-year time series of monthly mean relative sunshine duration
(dimensionless)}

\item{rl.elv}{single-layer Raster* object with the elevation values (in meters above sea level)}

\item{sc.year}{'numeric' scalar with the value of the year (using astronomical year numbering)}

\item{aprchTEMP}{'character' vector of length 1 that indicates the scheme used to generate daily values of the
daily mean air temperature for a specific year. Valid values are as follows: \cr
(a) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean air temperature in order to generate daily values; \cr
(b) \code{'tsi'} -
this scheme uses an iterative interpolation technique (Lüdeke et al. 1994) to time series of the monthly mean
air temperature, in order to generate a synthetic time series of the selected meteorological variable at a
temporal resolution that is higher than the daily scale; finally, this synthetic time series is upscaled to a
daily resolution; \cr
(c) \code{'const'} -
this scheme is assumed that values of the daily mean air temperature are constant within each month.}

\item{aprchBSDF}{'character' vector of length 1 that indicates the scheme used to generate daily values of the
daily fractional sunshine duration for a specific year. Valid values are as follows: \cr
(a) \code{'hip'} -
this scheme applies the mean-preserving 'harmonic' interpolation method of Epstein (1991) to the values of
monthly mean relative sunshine duration in order to generate daily values; \cr
(b) \code{'const'} -
this scheme is assumed that values of the daily relative sunshine duration are constant within each month.}

\item{dvTEMP}{'numeric' vector of length 12 with monthly values of the damping variable for the air temperature
data.}

\item{verbose}{'logical' scalar that indicates whether or not values of the bioclimatic indices used should be
added to the output.}

\item{filename}{output filename}

\item{...}{additional arguments passed on to \code{\link[raster]{writeRaster}}}
}
\value{
Depending on the settings, a RasterStack with two or more layers where the presence/absence data are
    stored in layers labelled \code{'fsp_hlz'}, \code{'fsp_fai'} and \code{'fsp_svm'}, while the additional layers
    contain the values of bioclimatic indices used. If \code{verbose = FALSE}, the return object is a two- or
    three-layer RasterStack with presence/absence data, depending on the available data.
}
\description{
Calculates the values of bioclimatic indices used in forest-steppe models with different theoretical
    backgrounds, and estimates the presence/absence of 'forest-steppe' ecotone, for a given region and year/epoch,
    by using the monthly time series of climate variables, and the elevation data.
}
\details{
See \code{\link[macroBiome]{cliForestSteppePoints}}.
}
\note{
The objects \code{'rs.temp'}, \code{'rs.prec'} and \code{'rs.bsdf'} must be 12-layer Raster* objects, while
    the object \code{'rl.elv'} has to be a single-layer Raster* object. These Raster* objects must have the same
    bounding box, projection, and resolution. The object \code{'sc.year'} has to be a single integer number.
}
\examples{
# Loading mandatory data for the Example 'Climate Normal Grid'
data(inp_exClnrGrid)

# Predict the 'forest-steppe' ecotone (using the related bioclimatic indices),
# with default settings, for Csongrad-Csanad County (for the normal period 1981-2010)
with(inp_exClnrGrid, {
year <- trunc(mean(seq(1981, 2010)))
rs.fsp1 <- cliForestSteppeGrid(temp, prec, verbose = TRUE)
rs.fsp1
})

\donttest{
# Predict the 'forest-steppe' ecotone (using the related bioclimatic indices),
# with default settings, for Csongrad-Csanad County (for the normal period 1981-2010)
with(inp_exClnrGrid, {
year <- trunc(mean(seq(1981, 2010)))
rs.fsp2 <- cliForestSteppeGrid(temp, prec, bsdf, elv, sc.year = year, verbose = TRUE)
rs.fsp2
})
}

}
\references{
\cite{Epstein ES (1991) On Obtaining Daily Climatological Values from Monthly Means. J Clim 4(3):365–368.
    \doi{10.1175/1520-0442(1991)004<0365:OODCVF>2.0.CO;2}}

\cite{Lüdeke MKB, Badeck FW, Otto RD, Häger C, Dönges S, Kindermann J, Würth G, Lang T, Jäkel U, Klaudius A,
    Ramge P, Habermehl S, Kohlmaier GH (1994) The Frankfurt Biosphere Model: A global process-oriented model of
    seasonal and long-term CO2 exchange between terrestrial ecosystems and the atmosphere. I. Model description
    and illustrative results for cold deciduous and boreal forests. Clim Res 4(2):143-166. \doi{10.3354/cr004143}}
}
