% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/predict-methods.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict-methods}
\alias{predict,saeObj-method}
\alias{predict,sadObj-method}
\title{Methods for Function \code{predict}}
\usage{
predict(object, ...)

\S4method{predict}{sadObj}(object)

\S4method{predict}{saeObj}(object, version = NULL, use_lm = NA)
}
\arguments{
\item{object}{a model object for which prediction is desired.}

\item{...}{Arguments to be passed to methods.}

\item{version}{set to "1.0.0" or set options(maSAE_version = "1.0.0")
to use the functions from maSAE 1.0.0. See NEWS.md for 2.0.0.}

\item{use_lm}{Rather for internal use, stick with the default.}
}
\value{
A data frame containing predictions and variances for each small
area, see \bold{Details} above.
}
\description{
Calculate small area predictions and their variances.
}
\details{
Based on the structure of the \code{saeObj} given, \code{predict} decides,
which
predictor to use:\cr
If a smallAreaMeans-data.frame covering all fixed effects is given, the
exhaustive
estimator \eqn{\hat{\tilde{y}}_{g, synth}} is calculated.  \cr
If a smallAreaMeans-data.frame not covering all fixed effects is given, the
partially
exhaustive
estimator \eqn{\hat{\tilde{y}}_{g, greg}} is calculated.  \cr
If no smallAreaMeans-data.frame but s1 is given, the three-phase
estimator \eqn{\hat{\tilde{y}}_{g, g3reg}} is calculated.  \cr
If neither smallAreaMeans nor s1 are given, the non-exhaustive
estimator \eqn{\hat{\tilde{y}}_{g, psynth}} is calculated.  \cr
If a clustering variable is given, the cluster sampling design equivalents
of the
above estimators are used.\cr
If \code{version} is not set to "1.0.0", the (pseudo) small and synthetic
estimations and their variances are also calculated (see
\code{vignette("A_Taxonomy_of_Estimators", package = "maSAE")})
}
\section{Methods}{
 \describe{

\item{\code{signature(object = saeObj)}}{Calculate predictions and variances
according to the auxiliary information given, see \bold{Details} above.}

\item{\code{signature(object = sadObj)}}{Calculate design-based predictions
and
variances.}
}
}

\examples{
## ## design-based estimation
## load data
data("s2", package = "maSAE")
## create object
saeO <- maSAE::saObj(data = s2, f = y ~ NULL | g)
## design-based estimation for all small areas given by g
maSAE::predict(saeO)
## ## model-assisted estimation
## load  data
data("s1", "s2", package = "maSAE")
str(s1)
s12 <- maSAE::bind_data(s1, s2)
## create object
saeO <- maSAE::saObj(data = s12, f = y ~ x1 + x2 + x3 | g, s2 = "phase2")
## small area estimation
maSAE::predict(saeO)
}
\seealso{
\code{vignette(package = "maSAE")}
}
\keyword{methods}
