#' Example s0 Data Set
#'
#' Artificial null phase sampling data used for examples in \pkg{maSAE}.
#'
#'  \describe{
#'    \item{\code{clustid}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{x1}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{x2}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{x3}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{inclusion}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{g}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'  }
#' @docType data
#' @keywords datasets
#' @format A data frame with 9008 observations on the following 6 variables.
#' @usage data(s0, package = "maSAE")
#' @name s0
NULL

#' Example s1 Data Set
#'
#' Artificial first phase sampling data  used for examples  in \pkg{maSAE}.
#'
#'
#'  \describe{
#'    \item{\code{clustid}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{x1}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{x2}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{x3}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{inclusion}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'    \item{\code{g}}{See \code{"\link[=s2]{?maSAE::s2}"}}
#'  }
#' @docType data
#' @keywords datasets
#' @format A data frame with 786 observations on the following 6 variables.
#' @usage data(s1, package = "maSAE")
#' @name s1
NULL

#' Example s2 Data Set
#'
#' Artificial second phase sampling data  used for examples in \pkg{maSAE}.
#'
#'
#'  \describe{
#'    \item{\code{clustid}}{index giving the clusters}.
#'    \item{\code{x1}}{a potential fixed effect.}
#'    \item{\code{x2}}{another potential fixed effect.}
#'    \item{\code{x3}}{yet another potential fixed effect.}
#'    \item{\code{y}}{the predictand}
#'    \item{\code{inclusion}}{a logical vector indicating whether or not to include the
#'    current observation. All TRUE.}
#'    \item{\code{g}}{A factor defining the small areas `a` and `b`}
#'  }
#'
#' @docType data
#' @keywords datasets
#' @format A data frame with 206 observations on the following 7 variables.
#' @usage data(s2, package = "maSAE")
#' @name s2
NULL
