% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-mailbox.R
\name{select_mailbox}
\alias{select_mailbox}
\title{Mailbox Selection}
\usage{
select_mailbox(imapconf, mbox, retries = 2)
}
\arguments{
\item{imapconf}{A object of class \code{imapconf} generated with
\link{configure_imap}.}

\item{mbox}{A string containing the name of an existing mailbox on the server.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
The (invisible) \code{imaconf} object with the selected mailbox added to it.
}
\description{
Select a mailbox on the server for issuing further commands.
}
\examples{
\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configureIMAP(url="imaps://imap.gmail.com",
                          username="your_gmail_user",
                          password=rstudioapi::askForPassword()
                         )

# Select INBOX
imapconf \%>\%
  select_mailbox(mbox = "INBOX")

}
}
\seealso{
Other mailbox commands: \code{\link{examine_mailbox}},
  \code{\link{list_mailboxes}},
  \code{\link{list_server_capabilities}},
  \code{\link{rename_mailbox}}
}
\concept{mailbox commands}
