% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simulateLSM.R
\name{simulateLSM}
\alias{simulateLSM}
\title{Simulate from LSM model}
\usage{
simulateLSM(object, Y = NULL, nsim = 100, seed, directed = NULL)
}
\arguments{
\item{object}{object of class \code{'lsm'}}

\item{Y}{(\code{N} x \code{N}) binary adjacency matrix}

\item{nsim}{number of simulations. Default \code{nsim = 100}}

\item{seed}{for simulations}

\item{directed}{if the network is directed or not.  Default \code{directed = NULL}}
}
\description{
Function to simulate networks from the LSM model
}
\examples{
n <- 20
Y <- network(n, directed = FALSE)[,]

modLSM <- lsm(Y, D = 2)

Ysim <- simulateLSM(modLSM, Y = Y, nsim = 8)
# store EZ, to keep the nodes in the same positions
# and compare the networks
EZ <- modLSM$lsmEZ
par(mfrow = c(3,3))
plotY(Y, EZ = EZ, main = "Original Data")
for(i in 1:8) plotY(Ysim[[i]], EZ = EZ, main = paste("Simulation" , i))
par(mfrow = c(1,1))
}

