% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfsim.akmeans.R
\name{cfsim.akmeans}
\alias{cfsim.akmeans}
\title{Compare LSBCLUST Simulation Results}
\usage{
\method{cfsim}{akmeans}(fitted, actual, method = c("diag", "cRand"))
}
\arguments{
\item{fitted}{An object of class \code{akmeans} containing the fitted results.}

\item{actual}{An object of class \code{lsbclust_sim} containing the simulated data.}

\item{method}{The method for calculating cluster agreement across random starts, passed on
to \code{\link{cl_agreement}}. None is calculated when set to \code{NULL}.}
}
\description{
This function compares cluster membership and parameter estimates for the results of
\code{\link{akmeans}} on simulated data, constructed using \code{\link{rlsbclust}}, 
to the true underlying values.
}
\examples{
## Simulate LSBCLUST data, fit akmeans on double-centered data, and compare
set.seed(1)
dat <- rlsbclust(ndata = 1, nobs = 100, size = c(10, 8), nclust = c(5, 4, 6, 5))
dat[[1]]$data <- carray(dat[[1]]$data)
res <- akmeans(data = dat[[1]]$data, centers = 5, margin = 3, ndim = 2)
cfsim(res, dat[[1]])
}
