% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicate_var.R
\name{replicate_var}
\alias{replicate_var}
\title{Sampling variance of the mean for replications}
\usage{
replicate_var(
  data_whole,
  data_rep,
  method,
  k = 0,
  weight_var = NULL,
  stat = weighted.mean,
  vars = NULL,
  full_output = FALSE
)
}
\arguments{
\item{data_whole}{full, original dataset (the one that generated the replications)}

\item{data_rep}{list with replications of `data_whole`}

\item{method}{replication method. Can be "Jackknife", "BRR" or "BRR Fay"}

\item{k}{deflating weight factor (used only when `method = "BRR Fay")}

\item{weight_var}{variables containing the weights}

\item{stat}{statistic of interest to calculate (must be a base R function)}

\item{vars}{vector containing the variables of interest}

\item{full_output}{if `TRUE`, returns all intermediate objects created}
}
\description{
Estimates the mean variance for Jackknife, BRR and BRR Fay replication methods
}
\details{
`data_rep` can be obtained from
}
\seealso{
jackknife brr
}
