% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{powerOneRateExact}
\alias{powerOneRateExact}
\title{Power for Poisson one-sample exact test}
\usage{
powerOneRateExact(
  n = NA_real_,
  lambdaH0 = NA_real_,
  lambda = NA_real_,
  D = 1,
  alpha = 0.025
)
}
\arguments{
\item{n}{The sample size.}

\item{lambdaH0}{The Poisson rate under the null hypothesis.}

\item{lambda}{The Poisson rate under the alternative hypothesis.}

\item{D}{The average exposure per subject.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
A data frame containing the critical value of the number of
events for rejecting the null hypothesis, the attained type I
error, the power for the exact test, the sample size,
the Poisson rates under the null and alternative hypotheses,
the average exposure, and the direction of the alternative.
}
\description{
Obtains the power for Poisson one-sample exact test.
}
\examples{
powerOneRateExact(n = 525, lambdaH0 = 0.049, lambda = 0.012,
                  D = 0.5, alpha = 0.025)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
