% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{powerRiskDiffExactEquiv}
\alias{powerRiskDiffExactEquiv}
\title{Power for exact unconditional test of equivalence in risk
difference}
\usage{
powerRiskDiffExactEquiv(
  n = NA_real_,
  riskDiffLower = NA_real_,
  riskDiffUpper = NA_real_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  allocationRatioPlanned = 1,
  alpha = 0.05,
  calculateAttainedAlpha = 1L
)
}
\arguments{
\item{n}{The total sample size.}

\item{riskDiffLower}{The lower equivalence limit of risk difference.}

\item{riskDiffUpper}{The upper equivalence limit of risk difference.}

\item{pi1}{The assumed probability for the active treatment group.}

\item{pi2}{The assumed probability for the control group.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{calculateAttainedAlpha}{Whether to calculate the attained alpha.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{alpha}: The specified significance level for each of the two
one-sided tests.
\item \code{attainedAlphaH10}: The attained significance level under H10
if requested.
\item \code{attainedAlphaH20}: The attained significance level under H20
if requested.
\item \code{power}: The power.
\item \code{n}: The sample size.
\item \code{riskDiffLower}: The lower equivalence limit of risk difference.
\item \code{riskDiffUpper}: The upper equivalence limit of risk difference.
\item \code{pi1}: The assumed probability for the active treatment group.
\item \code{pi2}: The assumed probability for the control group.
\item \code{riskDiff}: The risk difference.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{zstatRiskDiffLower}: The efficacy boundaries on the
z-test statistic scale for the one-sided null hypothesis on the
lower equivalence limit.
\item \code{zstatRiskDiffUpper}: The efficacy boundaries on the
z-test statistic scale for the one-sided null hypothesis on the
upper equivalence limit.
}
}
\description{
Obtains the power given sample size for exact unconditional
test of equivalence in risk difference.
}
\examples{

powerRiskDiffExactEquiv(
  n = 200, riskDiffLower = -0.2, riskDiffUpper = 0.2,
  pi1 = 0.775, pi2 = 0.775, alpha = 0.05)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
