% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{remlOddsRatio}
\alias{remlOddsRatio}
\title{REML estimates of individual proportions with specified odds
ratio}
\usage{
remlOddsRatio(oddsRatioH0, n1, y1, n2, y2)
}
\arguments{
\item{oddsRatioH0}{The specified odds ratio.}

\item{n1}{The sample size for the active treatment group.}

\item{y1}{The number of responses for the active treatment group.}

\item{n2}{The sample size for the control group.}

\item{y2}{The number of responses for the control group.}
}
\value{
A vector of the restricted maximum likelihood estimates
of the response probabilities for the two treatment groups.
}
\description{
Obtains the restricted maximum likelihood estimates of
individual proportions with specified odds ratio.
}
\examples{

remlOddsRatio(oddsRatioH0 = 1.25, n1 = 10, y1 = 4, n2 = 20, y2 = 2)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
