% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignRiskRatioEquiv}
\alias{getDesignRiskRatioEquiv}
\title{Group Sequential Design for Equivalence in Two-Sample
Risk Ratio}
\usage{
getDesignRiskRatioEquiv(
  beta = NA_real_,
  n = NA_real_,
  riskRatioLower = NA_real_,
  riskRatioUpper = NA_real_,
  pi1 = NA_real_,
  pi2 = NA_real_,
  nullVariance = FALSE,
  allocationRatioPlanned = 1,
  rounding = TRUE,
  kMax = 1L,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{riskRatioLower}{The lower equivalence limit of risk ratio.}

\item{riskRatioUpper}{The upper equivalence limit of risk ratio.}

\item{pi1}{The assumed probability for the active treatment group.}

\item{pi2}{The assumed probability for the control group.}

\item{nullVariance}{Whether to use the variance under the null or
the empirical variance under the alternative.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates. Fixed prior to the trial.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}
}
\value{
An S3 class \code{designRiskRatioEquiv} object with three
components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The significance level for each of the two one-sided
tests. Defaults to 0.05.
\item \code{attainedAlphaH10}: The attained significance level under H10.
\item \code{attainedAlphaH20}: The attained significance level under H20.
\item \code{kMax}: The number of stages.
\item \code{information}: The maximum information.
\item \code{expectedInformationH1}: The expected information under H1.
\item \code{expectedInformationH10}: The expected information under H10.
\item \code{expectedInformationH20}: The expected information under H20.
\item \code{numberOfSubjects}: The maximum number of subjects.
\item \code{expectedNumberOfSubjectsH1}: The expected number of subjects
under H1.
\item \code{expectedNumberOfSubjectsH10}: The expected number of subjects
under H10.
\item \code{expectedNumberOfSubjectsH20}: The expected number of subjects
under H20.
\item \code{riskRatioLower}: The lower equivalence limit of risk ratio.
\item \code{riskRatioUpper}: The upper equivalence limit of risk ratio.
\item \code{pi1}: The assumed probability for the active treatment group.
\item \code{pi2}: The assumed probability for the control group.
\item \code{riskRatio}: The risk ratio.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale for
each of the two one-sided tests.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha for each of
the two one-sided tests.
\item \code{cumulativeAttainedAlphaH10}: The cumulative alpha attained
under H10.
\item \code{cumulativeAttainedAlphaH20}: The cumulative alpha attained
under H20.
\item \code{efficacyRiskRatioLower}: The efficacy boundaries on the
risk ratio scale for the one-sided null hypothesis on the
lower equivalence limit.
\item \code{efficacyRiskRatioUpper}: The efficacy boundaries on the
risk ratio scale for the one-sided null hypothesis on the
upper equivalence limit.
\item \code{efficacyP}: The efficacy bounds on the p-value scale for
each of the two one-sided tests.
\item \code{information}: The cumulative information.
\item \code{numberOfSubjects}: The number of subjects.
}
\item \code{settings}: A list containing the following input parameters:
\itemize{
\item \code{typeAlphaSpending}: The type of alpha spending.
\item \code{parameterAlphaSpending}: The parameter value for alpha
spending.
\item \code{userAlphaSpending}: The user defined alpha spending.
\item \code{spendingTime}: The error spending time at each analysis.
\item \code{nullVariance}: Whether to use the variance under the null or
the empirical variance under the alternative.
\item \code{varianceRatioH10}: The ratio of the variance under H10 to
the variance under H1.
\item \code{varianceRatioH20}: The ratio of the variance under H20 to
the variance under H1.
\item \code{varianceRatioH12}: The ratio of the variance under H10 to
the variance under H20.
\item \code{varianceRatioH21}: The ratio of the variance under H20 to
the variance under H10.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{rounding}: Whether to round up sample size.
}
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for a group sequential design for equivalence in
two-sample risk ratio.
}
\examples{

(design1 <- getDesignRiskRatioEquiv(
  beta = 0.2, n = NA, riskRatioLower = 0.8,
  riskRatioUpper = 1.25, pi1 = 0.12, pi2 = 0.12,
  kMax = 3, alpha = 0.05, typeAlphaSpending = "sfOF"))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
