% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{remlRiskRatio}
\alias{remlRiskRatio}
\title{REML Estimates of Individual Proportions With Specified Risk
Ratio}
\usage{
remlRiskRatio(
  riskRatioH0 = 1,
  n1 = NA_real_,
  y1 = NA_real_,
  n2 = NA_real_,
  y2 = NA_real_
)
}
\arguments{
\item{riskRatioH0}{The specified risk ratio.}

\item{n1}{The sample size for the active treatment group.}

\item{y1}{The number of responses for the active treatment group.}

\item{n2}{The sample size for the control group.}

\item{y2}{The number of responses for the control group.}
}
\value{
A vector of the restricted maximum likelihood estimates
of the response probabilities for the two treatment groups.
}
\description{
Obtains the restricted maximum likelihood estimates of
individual proportions with specified risk ratio.
}
\examples{

remlRiskRatio(riskRatioH0 = 1.2, n1 = 10, y1 = 4, n2 = 20, y2 = 2)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
