% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fseqbon}
\alias{fseqbon}
\title{Group sequential trials using Bonferroni-based graphical 
approaches}
\usage{
fseqbon(
  w,
  G,
  alpha = 0.025,
  typeAlphaSpending = NA_character_,
  parameterAlphaSpending = NA_real_,
  incidenceMatrix = NA_integer_,
  maxInformation = NA_real_,
  information = NA_real_,
  p = NA_real_,
  spendingTime = matrix(0, 1, 1),
  repeatedPValueFlag = 0L
)
}
\arguments{
\item{w}{The vector of initial weights for elementary hypotheses.}

\item{G}{The initial transition matrix.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The vector of alpha spending functions. 
Each element is one of the following: 
"OF" for O'Brien-Fleming boundaries, 
"P" for Pocock boundaries, "WT" for Wang & Tsiatis boundaries, 
"sfOF" for O'Brien-Fleming type spending function, 
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, 
"sfHSD" for Hwang, Shi & DeCani spending function, 
and "none" for no early efficacy stopping.}

\item{parameterAlphaSpending}{The vector of parameter values for the 
alpha spending functions. Each element corresponds to the value of 
Delta for "WT", rho for "sfKD", or gamma for "sfHSD".}

\item{incidenceMatrix}{The incidence matrix indicating whether the 
specific hypothesis will be tested at the given look.}

\item{maxInformation}{The vector of targeted maximum information for each 
hypothesis.}

\item{information}{The matrix of observed information for each hypothesis 
by look.}

\item{p}{The matrix of raw p-values for each hypothesis by look.}

\item{spendingTime}{The spending time for alpha spending. Defaults to 
missing, in which case, it is the same as \code{informationRates} 
calculated from \code{information} and \code{maxInformation}.}

\item{repeatedPValueFlag}{Flag for whether to report the repeated 
p-values. Defaults to FALSE.}
}
\value{
A list with a component vector to indicate the first look the 
  specific hypothesis rejected (0 if the hypothesis is not rejected) and,  
  if \code{reppfl = 1}, a component matrix for the repeated p-values for 
  each hypothesis over time.
}
\description{
Obtains the test results for group sequential trials using 
graphical approaches based on weighted Bonferroni tests.
}
\examples{

# Case study from Maurer & Bretz (2013) 

fseqbon(
  w = c(0.5, 0.5, 0, 0),
  G = matrix(c(0, 0.5, 0.5, 0,  0.5, 0, 0, 0.5,  
               0, 1, 0, 0,  1, 0, 0, 0), 
             nrow=4, ncol=4, byrow=TRUE),
  alpha = 0.025,
  typeAlphaSpending = rep("sfOF", 4),
  incidenceMatrix = matrix(1, nrow=4, ncol=3),
  maxInformation = rep(1,4),
  information = matrix(c(rep(1/3, 4), rep(2/3, 4)), nrow=4, ncol=2),
  p = matrix(c(0.0062, 0.017, 0.009, 0.13, 
               0.0002, 0.0035, 0.002, 0.06), 
             nrow=4, ncol=2),
  repeatedPValueFlag = 1)


}
\references{
Willi Maurer and Frank Bretz. Multiple testing in group sequential
trials using graphical approaches. Statistics in Biopharmaceutical 
Research. 2013;5:311-320. \doi{10.1080/19466315.2013.807748}
}
