% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lori.R
\name{null_model}
\alias{null_model}
\title{Estimation algorithm for the LORI parameters without interactions.}
\usage{
null_model(Y, lambda2, cov = NULL, thresh = 1e-06, maxit = 1000,
  trace.it = T, reff = T, ceff = T)
}
\arguments{
\item{Y}{[matrix, data.frame] count table (nxp).}

\item{lambda2}{[positive number] the regularization parameter for the covariate effects.}

\item{cov}{[matrix, data.frame] design matrix (np*q) in order row1xcol1,row2xcol2,..,rownxcol1,row1xcol2,row2xcol2,...,...,rownxcolp}

\item{thresh}{[positive number] convergence tolerance of algorithm, by default \code{1e-6}.}

\item{maxit}{[integer] maximum allowed number of iterations.}

\item{trace.it}{[boolean] whether convergence information should be printed}

\item{reff}{[boolean] whether row effects should be fitted, default value is TRUE}

\item{ceff}{[boolean] whether column effects should be fitted, default value is TRUE}
}
\description{
Estimation algorithm for the LORI parameters without interactions.
}
\examples{
\dontrun{
X = matrix(rnorm(50), 25)
Y <- matrix(rpois(25, 1:25), 5)
res <- null_model(Y, 100, 100, X)
}
}
