% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{log_write}
\alias{log_write}
\title{Formatting and writing of the log.rx object to a log file}
\usage{
log_write(
  file = NA,
  remove_log_object = TRUE,
  show_repo_url = FALSE,
  include_rds = FALSE,
  to_report = c("messages", "output", "result")
)
}
\arguments{
\item{file}{String. Path to file executed}

\item{remove_log_object}{Boolean. Should the log object be removed after
writing the log file? Defaults to TRUE}

\item{show_repo_url}{Boolean. Should the repo URLs be reported
Defaults to FALSE}

\item{include_rds}{Boolean. Option to export log object as Rds file.
Defaults to FALSE}

\item{to_report}{String vector. Objects to optionally report; additional
information in \code{\link{axecute}}}
}
\value{
Nothing
}
\description{
\code{log_write()} gets and formats the content of the log.rx before writing it
to a log file
}
\examples{
dir <- tempdir()
text <- 'print("Hello, Timberperson!")'
fileConn <- file(file.path(dir, "hello.R"))
writeLines(text, fileConn)
close(fileConn)

file <- file.path(dir, "hello.R")

# Initialise and configure the log.rx environment
log_config(file)

# Run the script and record results, outputs, messages, errors, and warnings
logrx:::run_safely_loudly(file)

# Write the log
log_write(file)
}
