% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{prune}
\alias{prune}
\title{Post-pruning using a fixed complexity penalty}
\usage{
prune(model, alpha, simplify = TRUE)
}
\arguments{
\item{model}{A fitted \code{logicDT} model}

\item{alpha}{A fixed complexity penalty value. This value should be
determined out-of-sample, e.g., performing hyperparameter optimization
on independent validation data.}

\item{simplify}{Should the pruned model be simplified with regard to the
input terms, i.e., should terms that are no longer in the tree contained
be removed from the model?}
}
\value{
The new \code{logicDT} model containing the pruned tree
}
\description{
Using a fitted \code{\link{logicDT}} model and a fixed complexity penalty
\code{alpha}, its logic decision tree can be (post-)pruned.
}
\details{
Similar to Breiman et al. (1984), we implement post-pruning by first
computing the optimal pruning path and then choosing the tree that is
pruned according to the specified complexity penalty.

If no validation data is available or if the tree shall be automatically
optimally pruned, \code{\link{cv.prune}} should be used instead which
employs k-fold cross-validation for finding the best complexity penalty
value.
}
