% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{handlers}
\alias{handlers}
\alias{message}
\alias{warning}
\alias{stop}
\title{loggit's Exception Handlers}
\usage{
message(..., domain = NULL, appendLF = TRUE, .loggit = TRUE, echo = TRUE)

warning(
  ...,
  call. = TRUE,
  immediate. = FALSE,
  noBreaks. = FALSE,
  domain = NULL,
  .loggit = TRUE,
  echo = TRUE
)

stop(..., call. = TRUE, domain = NULL, .loggit = TRUE, echo = TRUE)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or (for
    \code{message} only) a single condition object.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated, see also the note in \code{\link[base]{stop}}.}

\item{appendLF}{logical: should messages given as a character string
    have a newline appended?}

\item{.loggit}{Should loggit function execute? Defaults to \code{TRUE}.}

\item{echo}{Should loggit's log entry be echoed to the console, as well?
Defaults to \code{TRUE}.}

\item{call.}{logical, indicating if the call should become part of the
    warning message.}

\item{immediate.}{logical, indicating if the call should be output
    immediately, even if \code{\link[base]{getOption}("warn") <= 0}.}

\item{noBreaks.}{logical, indicating as far as possible the message should
    be output as a single line when \code{options(warn = 1)}.}
}
\description{
These exception handlers are identical to base R's \link[base:message]{message},
\link[base:warning]{warning}, and \link[base:stop]{stop}, but with included logging
of the exception messages via \code{loggit()}.
}
\examples{
  if (2 < 1) message("Don't say such silly things!")

  if (2 < 1) warning("You may want to review that math, and so this is your warning")

  if (2 < 1) stop("This is a completely false condition, which throws an error")

}
