% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_LD.R
\name{link_LD}
\alias{link_LD}
\title{Obtain LD at a locus from LDlink}
\usage{
link_LD(loc, pop = "CEU", r2d = "r2", token = "", ...)
}
\arguments{
\item{loc}{Object of class 'locus' generated by \code{\link[=locus]{locus()}}}

\item{pop}{A 1000 Genomes Project population, (e.g. YRI or CEU), multiple
allowed, default = "CEU". Passed to \code{LDlinkR::LDmatrix()}.}

\item{r2d}{Either "r2" for LD r^2 or "d" for LD D', default = "r2". Passed
to \code{LDlinkR::LDmatrix()}.}

\item{token}{Personal access token for accessing 1000 Genomes LD data via
LDlink API. See \code{LDlinkR} package documentation.}

\item{...}{Optional arguments such as \code{genome_build} which are passed on to
\code{LDlinkR::LDmatrix()}}
}
\value{
Returns a list object of class 'locus'. LD information is added as a
column \code{ld} in list element \code{data}.
}
\description{
Adds LD information to a 'locus' class object. It queries LDlink
(https://ldlink.nci.nih.gov/) via the \code{LDlinkR} package to retrieve linkage
disequilibrium (LD) information on a reference SNP.
}
\details{
Results are cached using \code{memoise} to reduce API requests.
}
\seealso{
\code{\link[=locus]{locus()}}
}
