% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qq.lmvar.R
\name{plot_qq.lmvar}
\alias{plot_qq.lmvar}
\title{QQ-plot for an object of class 'lmvar'}
\usage{
\method{plot_qq}{lmvar}(object_1, object_2 = NULL, ...)
}
\arguments{
\item{object_1}{Object of class 'lmvar'}

\item{object_2}{Object of class 'lm' or class 'lmvar'}

\item{...}{for compatibility with \code{\link{plot_qq}} generic.}
}
\description{
Function produces QQ-plots for an object of class 'lmvar' and, optionally, for another object of class 'lm' or 'lmvar'.
}
\details{
If \code{object_2} is specified, a QQ-plot for \code{object_1} and one for \code{object_2} will be
combined in the same plot.

If \code{object_2} id of class 'lm', it must contain the response vector \eqn{y}. I.e., one must run \code{\link[stats]{lm}}
with argument \code{y = TRUE}.
}
\examples{
if (interactive()){

library(lmvar)

# create a 'lmvar' model using the 'iris' data set
X = model.matrix(~ Species - 1, data = iris)
fit_lmvar = lmvar(iris$Petal.Length, X, X)

plot_qq(fit_lmvar)

# compare the 'lmvar' model with a lineair model
fit_lm = lm( Petal.Length ~ Species, data = iris, y = TRUE)

plot_qq(fit_lmvar, fit_lm)

# check whether inclustion of petal in model improves QQ-plot
X = model.matrix(~ Species + Petal.Width - 1, data = iris)
fit_lmvar_width = lmvar(iris$Petal.Length, X, X)

plot_qq(fit_lmvar, fit_lmvar_width)

}
}
\seealso{
\code{\link{plot_qq}}
}
