% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.lmvar.R
\name{vcov.lmvar}
\alias{vcov.lmvar}
\title{Variance-covarience matrix of the coefficients beta for an object of class 'lmvar'}
\usage{
\method{vcov}{lmvar}(object, mu = TRUE, sigma = TRUE, ...)
}
\arguments{
\item{object}{Object of class 'lmvar'}

\item{mu}{Specifies whether or not the covariance matrix for \eqn{\beta_\mu} is included in the returned matrix}

\item{sigma}{Specifies whether or not the  covariance matrix for \eqn{\beta_\sigma} is included in the returned matrix}

\item{...}{For compatibility with \code{\link[stats]{vcov}} generic}
}
\value{
A 'matrix' object containing the (approximate) variance-covariance matrix of the maximum-likelihood estimators
of \eqn{\beta_\mu} and \eqn{\beta_\sigma} in \code{object}.
}
\description{
Variance-covarience matrix (also simply called the 'covariance matrix') for the
maximum-likelihood estimators of \eqn{\beta_\mu} and \eqn{\beta_\sigma}.
The matrix is calculated with the assumption of asymptotic normality of maximum likelihood estimators.
This assumption is only valid in the limit of a large number of observations.
}
\details{
The variance-covariance matrix is calculated as \eqn{I^{-1} / n} where \eqn{I} is the Fisher
information matrix and \eqn{n} the number of observations.

When \code{mu = TRUE} and \code{sigma = TRUE}, the full covariance matrix for the combined vector
\eqn{(\beta_\mu, \beta_\sigma)} is returned.

When \code{mu = TRUE} and \code{sigma = FALSE}, only the covariance matrix for \eqn{\beta_\mu} is returned.

When \code{mu = FALSE} and \code{sigma = TRUE}, only the covariance matrix for \eqn{\beta_\sigma} is returned.
}
\seealso{
\code{\link{summary.lmvar}} for standard errors for \eqn{\beta_\mu} and \eqn{\beta_\mu}.

\code{\link{nobs.lmvar}} for the number of observations in an object of class 'lmvar'.

\code{\link{fisher}} for the Fisher information matrix of an object of class 'lmvar'.

See the vignette "Math" (to be viewed with \code{vignette("Math", "lmvar")}) for details.
}
