% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterNoise-method.R
\docType{methods}
\name{filterNoise}
\alias{filterNoise}
\alias{filterNoise,matrixOrframe,noise,missingOrnumeric,missingOrnumeric,missingOrnumeric,missingOrnumeric-method}
\title{Filter non-informative trajectories}
\usage{
filterNoise(data, noise, RTCutoff, RICutoff, propMissingCutoff, fcCutoff)


  \S4method{filterNoise}{matrixOrframe,noise,missingOrnumeric,missingOrnumeric,missingOrnumeric,missingOrnumeric}(data,
  noise, RTCutoff, RICutoff, propMissingCutoff, fcCutoff)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the samples as rows and features as columns.}

\item{noise}{an object of class \code{noise} containing time and individual to molecule sd ratios number of missing values and maximum fold changes.}

\item{RTCutoff}{\code{numeric} the R_T cutoff to remove non-informative trajectories.}

\item{RICutoff}{\code{numeric} the R_I to remove non-informative trajectories.}

\item{propMissingCutoff}{\code{numeric} maximum proportion of missing values in trajectories.}

\item{fcCutoff}{\code{numeric} the minimum fold change observed between the mean of any two time points.}
}
\value{
filterNoise returns an object of class \code{list} containing the following components:
\item{data}{\code{numeric} filtered data.}
\item{removedIndices}{\code{numeric} removed indices}
}
\description{
Function to remove non-informative trajectories
}
\details{
filterNoise removes noisy or non-informative profiles based on selected theresholds R_I, R_T (Straube \emph{et al.} 2015), maximum foldchanges and/or missing values.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
G1 <- kidneySimTimeGroup$group=="G1"
noiseTest <-investNoise(data=kidneySimTimeGroup$data[G1,],time=kidneySimTimeGroup$time[G1],
            sampleID=kidneySimTimeGroup$sampleID[G1])
data <-filterNoise(data=kidneySimTimeGroup$data[G1,],noise=noiseTest,RTCutoff=0.9,
              RICutoff=0.3,propMissingCutoff=0.5)$data
             
             
#Alternatively model-based clustering can be used for filtering
library(mclust)
clusterFilter <- Mclust(cbind(noiseTest@RT,noiseTest@RI),G=2)
plot(clusterFilter,what = "classification")
meanRTCluster <-tapply(noiseTest@RT,clusterFilter$classification,mean)
bestCluster <- names(meanRTCluster[which.min(meanRTCluster)])
filterdata <- kidneySimTimeGroup$data[G1,clusterFilter$classification==bestCluster]
              
}
}
\references{
Straube J., Gorse A.-D., Huang B.E., Le Cao K.-A. (2015).  \emph{A linear mixed model spline framework for analyzing time course 'omics' data} PLOSONE, 10(8), e0134540.
}
\seealso{
\code{\link{investNoise}}
}

